<?php
/**
* @package direct-project-innovation-initiative
* @subpackage views
* @filesource
*/ /** */

/* Note - this code applies the same id to many elements, which is invalid HTML and may cause unexpected behavior for js/css. 
If we're ever refactoring this code, we should consider changing the id="sender", id="subject", id="priority", etc. for table columns
to classes instead.  Additionally, it would be easier to work with this code if it was embedded PHP in HTML instetad of echoed strings,
so that we'd have the benefit of syntax highlighting/code formatting. - MG 2014-05-05 */

$mailbox_location = get_instance()->session->mailbox_location();
$mailbox_location_display_name = get_instance()->session->mailbox_location_display_name();
$is_group = get_instance()->mailbox->is_group;

$optional_vars = array( 'show_workflow' => '',
						'sort_column' => '',
						);

//make sure that optional vars all have a value
foreach( $optional_vars as $optional_var => $default_value){
	if(!isset($$optional_var)) $$optional_var = $default_value;
}

?>

<table id="messages" class="messages<?php if($is_group): ?> group<?php endif ?>" style="border-spacing: 1px;" summary="This table lists messages in the <?php echo $mailbox_location_display_name ?> folder. Each row contains a checkbox for selecting an individual message to perform an action, such as Archive, Move, or Mark as Read. Each table cell after the checkbox contains information about the message: The sender of the message, the subject (and the priority if applicable), the date it was sent, and the message size.">
	<caption class="hidden_context">List of messages in mailbox folder: <?php echo $mailbox_location_display_name ?></caption>
	<!--[if lte IE 8 ]>
		<colgroup span="<?php echo ($show_workflow ? '9' : '8') ?>">
			<col style="width: 20px;">
			<?php if($show_workflow): ?><col style="width: 20px;"><?php endif ?>
			<col style="width: 20px;">
			<col style="width: 100px;">
			<col style="width: 390px;">
			<col style="width: 20px;">
			<col style="width: 60px;">
			<col style="width: 80px;">
			<col style="width: 70px;">'
		</colgroup>	
	<![endif]-->		
	<tr class="header">
		<th scope="col" class="select">
			<label for="selectall" class="hidden_context">Select All</label>
			<input type="checkbox" name="selectall" id="selectall" onclick="selectAll()" />
		</th>
		<th scope="col" class="attachment"><img src="/images/paperclip.png" style="height: 15px;" alt="Has Attachment" title="Attachment" /></th>
	<?php if($show_workflow): ?>
		<th scope="col" class="status_icon"><a href="/inbox/sort/workflow"><img id="legend" src="/images/dark_man.png" style="width:12.5px;" alt="Status" title="Status" /><?php if($sort_column == 'workflow') echo $sort_icon ?></a></th>
	<?php endif ?>
		<th scope="col" class="sender"><a href="/inbox/sort/sender">From<?php if($sort_column == 'sender') echo $sort_icon ?></a></th>
		<th scope="col" class="subject" colspan="2"><a href="/inbox/sort/subject">Subject<?php if($sort_column == 'subject') echo $sort_icon ?></a></th>
		<th scope="col" class="flag"><a href="/inbox/sort/flag"><img src="/images/icons/flag_less_transparent.png" alt="Flag" title="Flag"/><?php if($sort_column == 'flag') echo $sort_icon ?></a></th>
		<th scope="col" class="priority"><a href="/inbox/sort/priority">Priority<?php if($sort_column == 'priority') echo $sort_icon ?></a></th>
		<th scope="col" class="date"><a href="/inbox/sort/timestamp">Date<?php if($sort_column == 'timestamp') echo $sort_icon ?></a></th>
		<th scope="col" class="size"><a href="/inbox/sort/size">Size<?php if($sort_column == 'size') echo $sort_icon ?></a></th>
		<?php if(isset($is_multiple_folder_search) && $is_multiple_folder_search === true) { ?>
		<th scope="col" class="folder">Folder</th>
		<?php }?>
		
		
		<?php //start markup with no differences ?>
	</tr>
<?php foreach($headers as $msg_uid => $message): ?>
	<?php $header = $message; ?>
	<?php $message_url = site_url('inbox/viewmsg/'.$message->id); ?>
	<tr<?php if(!$message->seen): ?> class="newmsg"<?php endif ?>>
		<td class="select">
			<label for="select<?php echo $message->id ?>" class="hidden_context">Select Message with Subject: <?php echo $message->subject_for_display ?></label>
			<input class="selectmsg" type="checkbox" name="select<?php echo $message->id ?>" id="select<?php echo $message->id ?>" onclick="selectMsg(this)" />
		</td>
		<td class="attachment">
		<?php if($message->has_attachments()): ?>
			<a href="<?php echo $message_url ?>">
				<img src="/images/paperclip.png" alt="Attachment Icon" />
			</a>
		<?php endif; ?>
		</td>
	<?php if($show_workflow): ?>
		<td class="workflow status_icon"><?php echo $this->load->view('inbox/messages/_workflow', compact('current_user', 'display_name', 'header'), TRUE); ?></td>
	<?php endif ?>
		<td class="sender">
			<a title="<?php echo $message->sender_for_display ?>" href="<?php echo $message_url ?>"><?php echo $message->sender_for_display ?></a>
		</td>
		<td class="subject"><?php echo $this->load->view('inbox/messages/_subject', compact('message'), TRUE) ?></td>
		<td class="patients bootstrap"><?php if(!$message->property_is_empty('patients')) echo $this->load->view('inbox/messages/_patients', compact('message'), TRUE) ?></td>
		<td class="flag"><?php echo $this->load->view('inbox/messages/_flag', compact('header', 'msg_uid'), TRUE) ?></td>
		<td class="priority">
			<a href="<?php echo $message_url ?>">
				<span title="<?php echo ucfirst($message->importance) ?> Priority" class="<?php echo $message->importance ?>_priority">
					<?php if($message->importance == 'high'): ?>!<?php elseif($message->importance == 'low'): ?>&#8595;<?php else: ?>&nbsp;<?php endif ?>
				</span>
			</a>
		</td>
		<td class="date"><a href="<?php echo $message_url ?>"><?php echo $message->timestamp_for_display() ?></a></td>
		<td class="size"><a href="<?php echo $message_url ?>"><?php echo $message->size_for_display()?></a></td>
		<?php if(isset($is_multiple_folder_search) && $is_multiple_folder_search === true) {?>
		<td class="size">
		<?php 
		if(isset($message->folder_id)) {
			$folder = $folders[$message->folder_id];
			echo replace_first_with('[Custom].', '', $folder->name);
		}
		else if($message->sent) {
			echo 'Sent';
		}
		else if($message->draft) {
			echo 'Drafts';
		}
		else if($message->archived) {
			echo 'Archive';
		}
		else {
			echo 'Inbox';
		}
		
			
			?>
		</td>
		<?php }?>
	</tr>
<?php endforeach ?>
</table>
<input style="display:none;" id="current_user" value="<?PHP echo $current_user;?>"/>
<input style="display:none;" id="display_name" value="<?PHP echo $display_name;?>"/>